import hexaly.optimizer
import sys

with hexaly.optimizer.HexalyOptimizer() as optimizer:
    PI = 3.14159265359

    #
    # Declare the optimization model
    #
    m = optimizer.model

    # Numerical decisions
    R = m.float(0, 1)
    r = m.float(0, 1)
    h = m.float(0, 1)

    # Surface must not exceed the surface of the plain disc
    surface = PI * r ** 2 + PI * (R + r) * m.sqrt((R - r) ** 2 + h ** 2)
    m.constraint(surface <= PI)

    # Maximize the volume
    volume = PI * h / 3 * (R ** 2 + R * r + r ** 2)
    m.maximize(volume)

    m.close()

    #
    # Parametrize the optimizer
    #
    if len(sys.argv) >= 3:
        optimizer.param.time_limit = int(sys.argv[2])
    else:
        optimizer.param.time_limit = 2

    optimizer.solve()

    #
    # Write the solution in a file with the following format:
    #  - surface and volume of the bucket
    #  - values of R, r and h
    #
    if len(sys.argv) >= 2:
        with open(sys.argv[1], 'w') as f:
            f.write("%f %f\n" % (surface.value, volume.value))
            f.write("%f %f %f\n" % (R.value, r.value, h.value))
