import com.hexaly.optimizer.*;

public class Toy {

    public static void main(String[] args) {
        int[] weights = { 10, 60, 30, 40, 30, 20, 20, 2 };
        int[] values = { 1, 10, 15, 40, 60, 90, 100, 15 };

        // Declare the optimization model
        try (HexalyOptimizer optimizer = new HexalyOptimizer()) {
            HxModel model = optimizer.getModel();

            // 0-1 decisions
            HxExpression[] x = new HxExpression[8];
            for (int i = 0; i < 8; ++i) {
                x[i] = model.boolVar();
            }

            // knapsackWeight <- 10*x0 + 60*x1 + 30*x2 + 40*x3 + 30*x4 + 20*x5 + 20*x6 + 2*x7;
            HxExpression knapsackWeight = model.sum();
            for (int i = 0; i < 8; ++i) {
                knapsackWeight.addOperand(model.prod(weights[i], x[i]));
            }

            // knapsackWeight <= 102;
            model.constraint(model.leq(knapsackWeight, 102));

            // knapsackValue <- 1*x0 + 10*x1 + 15*x2 + 40*x3 + 60*x4 + 90*x5 + 100*x6 + 15*x7;
            HxExpression knapsackValue = model.sum();
            for (int i = 0; i < 8; ++i) {
                knapsackValue.addOperand(model.prod(values[i], x[i]));
            }

            // maximize knapsackValue;
            model.maximize(knapsackValue);

            // Close model before solving it
            model.close();

            // Parametrize the optimizer
            optimizer.getParam().setTimeLimit(10);
            optimizer.solve();
        } catch (Exception ex) {
            System.err.println(ex);
            ex.printStackTrace();
            System.exit(1);
        }
    }
}
