#include "optimizer/hexalyoptimizer.h"
#include <iostream>

using namespace hexaly;
using namespace std;

int main() {
    try {
        hxint weights[] = {10, 60, 30, 40, 30, 20, 20, 2};
        hxint values[] = {1, 10, 15, 40, 60, 90, 100, 15};
        hxint knapsackBound = 102;

        // Declare the optimization model
        HexalyOptimizer optimizer;
        HxModel model = optimizer.getModel();

        // 0-1 decisions
        HxExpression x[8];
        for (int i = 0; i < 8; ++i)
            x[i] = model.boolVar();

        // knapsackWeight <- 10*x0 + 60*x1 + 30*x2 + 40*x3 + 30*x4 + 20*x5 + 20*x6 + 2*x7;
        HxExpression knapsackWeight = model.sum();
        for (int i = 0; i < 8; ++i)
            knapsackWeight.addOperand(weights[i] * x[i]);

        // knapsackWeight <= 102;
        model.constraint(knapsackWeight <= knapsackBound);

        // knapsackValue <- 1*x0 + 10*x1 + 15*x2 + 40*x3 + 60*x4 + 90*x5 + 100*x6 + 15*x7;
        HxExpression knapsackValue = model.sum();
        for (int i = 0; i < 8; ++i)
            knapsackValue.addOperand(values[i] * x[i]);

        // maximize knapsackValue;
        model.maximize(knapsackValue);

        // Close model before solving it
        model.close();

        // Parametrize the optimizer
        optimizer.getParam().setTimeLimit(10);
        optimizer.solve();

    } catch (const exception& e) {
        cerr << "An error occurred:" << e.what() << endl;
        return 1;
    }

    return 0;
}
