import hexaly.optimizer

with hexaly.optimizer.HexalyOptimizer() as optimizer:
    weights = [10, 60, 30, 40, 30, 20, 20, 2]
    values = [1, 10, 15, 40, 60, 90, 100, 15]
    knapsack_bound = 102

    #
    # Declare the optimization model
    #
    model = optimizer.model

    # 0-1 decisions
    x = [model.bool() for _ in range(8)]

    # Weight constraint
    knapsack_weight = model.sum(weights[i] * x[i] for i in range(8))
    model.constraint(knapsack_weight <= knapsack_bound)

    # Maximize value
    knapsack_value = model.sum(values[i] * x[i] for i in range(8))
    model.maximize(knapsack_value)

    model.close()

    # Parameterize the optimizer
    optimizer.param.time_limit = 10

    optimizer.solve()
