import os, sys
import localsolver


def getCompliance(arg_values) :
    x = arg_values[0]
    y = arg_values[1]
    l = arg_values[2]
    h = arg_values[3]

    command = "~/FreeFem++/FreeFem-sources/src/nw/FreeFem++ elasticbeam.edp -v 0"
    command += " -x " + str(x) + " -y " + str(y) + " -l " + str(l) + " -h " + str(h)
    command += " > temp.txt"
    os.system(command)
    with open("temp.txt", "r") as res :
        compStr = res.read()
    os.system("rm temp.txt 2> /dev/null")
    try:
        comp = float(compStr)
    except:
        comp = float('nan')
    return comp

def printMaterial(x, y, l, h):
    command = "~/FreeFem++/FreeFem-sources/src/nw/FreeFem++ elasticbeam.edp -v 0"
    command += " -x " + str(x) + " -y " + str(y) + " -l " + str(l) + " -h " + str(h)
    command += " -plot 1"
    os.system(command)
    

# Parameters
L = 10
H = 1
dmin = 0.2
Vmax = 0.9*L*H
Vmin = 0.1*L*H

with localsolver.LocalSolver() as ls:
    model = ls.model

    # Variables

    x = model.float(0, L)
    y = model.float(0, H)
    l = model.float(0, L)
    h = model.float(0, H)

    V0 = h*l
    V = L*H - V0

    # Constraints

    model.constraint(x >= dmin)
    model.constraint(y >= dmin)
    model.constraint(h >= dmin)
    model.constraint(l >= dmin)
    model.constraint(y + h + dmin <= 1)
    model.constraint(x + l + dmin <= L)

    model.constraint(V <= Vmax)
    model.constraint(V >= Vmin)

    # Black-box function

    func = model.double_external_function(getCompliance)
    surrogate_params = func.external_context.enable_surrogate_modeling()


    model.minimize(func([x, y, l, h]))
    model.close()

    ls.param.time_limit = 30

    ls.solve()

    printMaterial(x.value, y.value, l.value, h.value)

    



